<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Lists the course categories
 *
 * @copyright 1999 Martin Dougiamas  http://dougiamas.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @package course
 */

require_once("../config.php");
require_once($CFG->dirroot. '/course/lib.php');
require_once($CFG->libdir. '/coursecatlib.php');

$categoryid = optional_param('categoryid', 0, PARAM_INT); // Category id
$site = get_site();

if ($categoryid) {
    $PAGE->set_category_by_id($categoryid);
    $PAGE->set_url(new moodle_url('/course/index.php', array('categoryid' => $categoryid)));
    $PAGE->set_pagetype('course-index-category');
    // And the object has been loaded for us no need for another DB call
    $category = $PAGE->category;
} else {
    $categoryid = 0;
    $PAGE->set_url('/course/index.php');
    $PAGE->set_context(context_system::instance());
}

$PAGE->set_pagelayout('coursecategory');
$courserenderer = $PAGE->get_renderer('core', 'course');

if ($CFG->forcelogin) {
    require_login();
}

if ($categoryid && !$category->visible && !has_capability('moodle/category:viewhiddencategories', $PAGE->context)) {
    throw new moodle_exception('unknowncategory');
}

$PAGE->set_heading($site->fullname);
$content = $courserenderer->course_category($categoryid);

echo $OUTPUT->header();
echo $OUTPUT->skip_link_target();
echo $content;

echo $OUTPUT->custom_block_region('content');

//  /***********************************/

if($USER->id!=2){
global $USER, $DB, $CFG;
$time = time();
echo 'tttt' . $time;
date_default_timezone_set("America/New_York");
$todaytimestamp = strtotime(date('Y-m-d'));
$todaytimestamp;
$query = "SELECT * FROM {logstore_standard_log} where userid = $USER->id AND realuserid IS NULL AND courseid > 1 AND timecreated > $todaytimestamp";
$record = $DB->get_records_sql($query);
$record = array_values($record);
echo '<pre>record: ' . print_r($record, true) . '</pre><br />';
$count = count($record);
$timedifference = $record[$count-1]->timecreated - $record[0]->timecreated;
echo $timedifference;
$timelimit = 4*60*60;
if($timelimit<$timedifference) {
    $userobj = $DB->get_record_sql('SELECT * FROM {user} WHERE id = ' . $USER->id);
    $userobj->suspended = 1;
    $DB->update_record('user', $userobj);
    
    $suspenduser = new stdClass();
    $suspenduser->userid = $USER->id;
    $suspenduser->timecreated = $time;
    $suspenduser->flag = 1;
 echo '<pre>suspend: ' . print_r($suspenduser, true) . '</pre><br />';
    
    $query = "INSERT INTO rzm_suspend_user (userid,timecreated,flag) values($USER->id,$time,1)";
    $DB->execute($query);
    
$DB->insert_record('suspend_user', $suspenduser);
    require_logout();
   redirect($CFG->wwwroot.'/');
}
}
  $userQuery = $DB->get_record_sql('SELECT * FROM {suspened_user} WHERE id = ' . $USER->id);
  if($userQuery){
     
      
  }  

echo $OUTPUT->footer();
