<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Logs the user out and sends them to the home page
 *
 * @package    core
 * @subpackage auth
 * @copyright  1999 onwards Martin Dougiamas  http://dougiamas.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../config.php');
require_once('lib.php');

$PAGE->set_url('/login/logout.php');
$PAGE->set_context(context_system::instance());

$sesskey = optional_param('sesskey', '__notpresent__', PARAM_RAW); // we want not null default to prevent required sesskey warning
$login   = optional_param('loginpage', 0, PARAM_BOOL);

// can be overridden by auth plugins
if ($login) {
    $redirect = get_login_url();
} else {
    $redirect = $CFG->wwwroot.'/';
}

if (!isloggedin()) {
    // no confirmation, user has already logged out
    require_logout();
    redirect($redirect);

} else if (!confirm_sesskey($sesskey)) {
    $PAGE->set_title($SITE->fullname);
    $PAGE->set_heading($SITE->fullname);
    echo $OUTPUT->header();
    echo $OUTPUT->confirm(get_string('logoutconfirm'), new moodle_url($PAGE->url, array('sesskey'=>sesskey())), $CFG->wwwroot.'/');
    echo $OUTPUT->footer();
    die;
}

$authsequence = get_enabled_auth_plugins(); // auths, in sequence
foreach($authsequence as $authname) {
    $authplugin = get_auth_plugin($authname);
    $authplugin->logoutpage_hook();
}
//Added by Desmond - Commented on 09Mar2020 as this code is not required at logout as timer calculation changed for lesson pages alone.
/*global $USER, $DB;
date_default_timezone_set("America/New_York");
$todaytimestamp = strtotime(date('Y-m-d'));
//echo $todaytimestamp;
//echo "<br>";
$time_spent = time() - $_SESSION['logintime'];
//echo $time_spent;
//if in todaystimestampe already data exists then add that data otherwise create a new record in todays time stamp
$userid= $USER->id;

$dataexists = $DB->get_record('suspend_user', array('userid' => $userid,'date'=>$todaytimestamp), '*', IGNORE_MISSING) ;
//print_r($dataexists);
//die();
if($dataexists){
	$already_spent = $dataexists->timespent;
	$todayTimeSpent = $already_spent + $time_spent;	
	$dataexists->timespent = $todayTimeSpent;
	//print_r($dataexists);die();
	$DB->update_record('suspend_user', $dataexists);
}else{
	$userobj = new stdClass();
	$userobj->userid = $USER->id;
	$userobj->date = $todaytimestamp;
	$userobj->timespent = $time_spent;
	$DB->insert_record('suspend_user', $userobj);
}
unset($_SESSION['logintime']); 
unset($_SESSION['timeleft']);*/
//Added by Desmond
require_logout();

redirect($redirect);