<?php
define('CLI_SCRIPT', true);
require_once('../../config.php');
require_once("{$CFG->libdir}/completionlib.php");
global $DB, $CFG, $USER;

$PAGE->set_url($CFG->wwwroot. '/user/report/generatePDF.php');
$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('standard');
$PAGE->set_title('User Script');
$PAGE->set_heading('user mail');

$c_grade = $DB->get_records_sql("SELECT CONCAT(c.id, '_' ,mu.id) as cuid,c.fullname as cfullname, CONCAT(mu.firstname, ' ', mu.lastname) AS fullname, gg.timemodified AS completiondate, mu.email AS email, gg.finalgrade AS finalgrade
FROM {grade_items} AS gi
INNER JOIN {course} c ON c.id = gi.courseid
LEFT JOIN {grade_grades} AS gg ON gg.itemid = gi.id
INNER JOIN {user} AS mu ON gg.userid = mu.id
WHERE gi.itemtype = 'course' AND gg.timemodified > UNIX_TIMESTAMP(DATE_SUB(NOW(),INTERVAL 1 DAY))
ORDER BY gg.timemodified asc");





foreach($c_grade as $c_finalgrade)
{
$user_email = $c_finalgrade->email;
$comp_date = date('m/d/Y',$c_finalgrade->completiondate);
$userids =explode('_',$c_finalgrade->cuid);
$usersid = $userids[1];
$cursoid = $userids[0];
//$c_finalgrade->finalgrade;
$fnlgrade = (int)$c_finalgrade->finalgrade;
if($fnlgrade >= 70)
{
$user_license = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'LicenseNumber'");


$user_dob = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'DOB'");	

$user_gender = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'Gender'");

$user_fullname = $c_finalgrade->fullname;

$user_streetaddress = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'streetaddress'");

$user_phone = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'phone'");

$user_city = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'City'");


$user_state = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'State'");


$user_zip = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'ZipCode'");


$user_violations = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'violations'");


$user_accident = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'accident'");


$user_courtoriginator = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'courtoriginator'");


$user_courtname = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'court'");


$user_courtcasenum = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'CourtCase'");


$user_convictiondate = $DB->get_record_sql("SELECT ud.data
FROM {user_info_data} ud
JOIN {user_info_field} uf ON uf.id = ud.fieldid
WHERE ud.userid = $usersid
AND uf.shortname = 'conviction'");

}
}

if(!empty($c_grade)){
// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, 'px', 'A4', true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Desmond');
$pdf->SetTitle('Report');
$pdf->SetSubject('Report');

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
//$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// -------------------------------------------------------------------

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// set font
$pdf->SetFont('helvetica', '', 11);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// set bacground image
$img_file = K_PATH_IMAGES.'background.png';
$pdf->Image($img_file, 0, 0, 816, 1056, '', '', '', false, 300, '', false, false, 0);

$pdf->MultiCell('200','20', $user_license->data, 1, 'L', 1, 0, '87', '183', true);
$pdf->MultiCell('200','20', date('m/d/Y',$user_dob->data), 1, 'L', 1, 0, '257', '183', true);
//For male/female conditions
if($user_gender->data=='Male'){
	$pdf->Image('images/tick.png', '413', '187','16','12');
}elseif($user_gender->data=='Female'){
	$pdf->Image('images/tick.png', '472', '187','16','12');
}
$pdf->MultiCell('200','20', $user_fullname, 1, 'L', 1, 0, '87', '213', true);

$pdf->MultiCell('200','20', $user_streetaddress->data, 1, 'L', 1, 0, '87', '243', true);
$pdf->MultiCell('200','20', $user_phone->data, 1, 'L', 1, 0, '383', '243', true);

$pdf->MultiCell('200','20', $user_city->data, 1, 'L', 1, 0, '87', '273', true);
$pdf->MultiCell('200','20', $user_state->data, 1, 'L', 1, 0, '320', '273', true);
$pdf->MultiCell('200','20', $user_zip->data, 1, 'L', 1, 0, '383', '273', true);

$pdf->MultiCell('200','20', $user_violations->data, 1, 'L', 1, 0, '87', '297', true);
//For accident conditions
if($user_accident->data=='Yes'){
	$pdf->Image('images/tick.png', '402', '301','13','10');
}elseif($user_accident->data=='No'){
	$pdf->Image('images/tick.png', '438', '301','13','10');
}

$pdf->MultiCell('200','20', $user_courtoriginator->data, 1, 'L', 1, 0, '87', '340', true);
$pdf->MultiCell('200','20', $user_courtname->data, 1, 'L', 1, 0, '235', '340', true);

$pdf->MultiCell('200','20', $user_courtcasenum->data, 1, 'L', 1, 0, '87', '370', true);
$pdf->MultiCell('200','20', date('m/d/Y',$user_convictiondate->data), 1, 'L', 1, 0, '383', '370', true);

$pdf->MultiCell('200','20', 'Online CE, LLC', 1, 'L', 1, 0, '87', '420', true);

$pdf->MultiCell('250','20', '8670 West Cheyenne Avenue, Suite 120', 1, 'L', 1, 0, '87', '445', true);
$pdf->MultiCell('200','20', '(844) 812-8512', 1, 'L', 1, 0, '383', '445', true);

$pdf->MultiCell('200','20', 'Las Vegas', 1, 'L', 1, 0, '87', '475', true);
$pdf->MultiCell('200','20', 'NV', 1, 'L', 1, 0, '235', '475', true);
$pdf->MultiCell('200','20', '89129', 1, 'L', 1, 0, '383', '475', true);

$pdf->Image('images/tick.png', '204', '501','16','12');
$pdf->MultiCell('200','20', '(Online Course)', 1, 'L', 1, 0, '235', '505', true);

$pdf->Image('http://www.20dollartrafficschool.com/mod/certificate/pix/signatures/SignatureMO.png', '230', '568','128','25');
$pdf->MultiCell('200','20', $comp_date, 1, 'L', 1, 0, '383', '578', true);



// -------------------------------------------------------------------
$fname = $user_fullname.'_rep.pdf';
//Close and output PDF document
$pdf->Output(K_PATH_IMAGES.$fname, 'F');

//============================================================+
// END OF FILE
//============================================================+
//Now send email




$my_file = $fname;
$my_path = K_PATH_IMAGES;
$my_name = "20DollarTrafficSchool";
$my_mail = 'noreply@20dollartrafficschool.com';
$my_replyto = 'noreply@20dollartrafficschool.com';
$my_subject = 'Your Form 4444 from 20 Dollar Traffic School';
$my_message = "You will need 2 copies of this report. Take one copy to your court, and mail another copy to the address at the bottom of the form.";

mail_attachment($my_file, $my_path,$user_email, $my_mail, $my_name, $my_replyto, $my_subject, $my_message);
//mail_attachment($my_file, $my_path,"desmond_shun@yahoo.com", $my_mail, $my_name, $my_replyto, $my_subject, $my_message);
}

function mail_attachment($filename,$path, $mailto, $from_mail, $from_name, $replyto, $subject, $message) {
 $file = $path.$filename;
 $file_size = filesize($file);
 $handle = fopen($file, "r");
 $content = fread($handle, $file_size);
 fclose($handle);
 $content = chunk_split(base64_encode($content));
 $uid = md5(uniqid(time()));
 $eol = PHP_EOL;
 $header = "From: ".$from_name." <".$from_mail.">".$eol;
$header .= "Reply-To: ".$replyto.$eol;
$header .= "Bcc: certificates@20dollartrafficschool.com".$eol;
$header .= "MIME-Version: 1.0\r\n";
$header .= "Content-Type: multipart/mixed; boundary=\"".$uid."\"";

 $message = "--".$uid.$eol;
$message .= "Content-Type: text/html; charset=ISO-8859-1".$eol;
$message .= "Content-Transfer-Encoding: 8bit".$eol.$eol;
$message .= $body.$eol;
$message .= "--".$uid.$eol;
$message .= "Content-Type: application/pdf; name=\"".$filename."\"".$eol;
$message .= "Content-Transfer-Encoding: base64".$eol;
$message .= "Content-Disposition: attachment; filename=\"".$filename."\"".$eol;
$message .= $content.$eol;
$message .= "--".$uid."--";
 if (mail($mailto, $subject, $message, $header)) {
 echo "mail sent ... OK"; // or use booleans here
 } else {
 echo "mail sent ... ERROR!";
 }
}