<?php

/**
 * Ask question form
 */
require_once('../../config.php');
require_once($CFG->libdir . '/formslib.php');
require_once('lib.php');
require_login();
$siteurl = $CFG->wwwroot . '/course/view.php';

global $USER, $CFG, $DB;
echo $OUTPUT->header();

$profile_field_category_id = get_config('local_askquestion', 'security_question_profile_field_category_id');
$profile_fields = $DB->get_records('user_info_field', array('categoryid' => $profile_field_category_id));

if($_POST){
    //print_r($_POST);
    $correct=0;
    $shortnames = $_POST['shortnames'];
    foreach($shortnames as $profileshortname){
        $profilefieldinfo = $DB->get_record('user_info_field', array('shortname' => $profileshortname));

        if ($DB->record_exists('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id))) {
            $datarow = $DB->get_record('user_info_data', array('userid' => $USER->id, 'fieldid' => $profilefieldinfo->id));
            if($_POST[$profileshortname]==$datarow->data){
                $correct+=1;
            }
        }
        
    }
    if(count($shortnames)==$correct){
        //echo 'all correct';
        
        $userobj = new stdClass();
        $userobj->id = $USER->id;
        $userobj->locked = 0;
        $return = $DB->update_record('user', $userobj);
        $_SESSION['how_many_times_failed_in_answering'] = 0;
        redirect($siteurl);
    }else{
        //echo 'wrong answers';
        
        if (isset($_SESSION['how_many_times_failed_in_answering'])) {
            $_SESSION['how_many_times_failed_in_answering'] = $_SESSION['how_many_times_failed_in_answering'] + 1;
        } else {
            $_SESSION['how_many_times_failed_in_answering'] = 1;
        }
        

        $max_attempt_allowed = get_config('local_askquestion', 'max_attempt_allowed_in_security_question');

        if ($_SESSION['how_many_times_failed_in_answering'] >= $max_attempt_allowed) {
            
        } else if ($_SESSION['how_many_times_failed_in_answering'] < $max_attempt_allowed) {
            $remaning_attempt = $max_attempt_allowed - $_SESSION['how_many_times_failed_in_answering'];
            $errors['securityquestion'] = get_string('errormsg', 'local_askquestion', $remaning_attempt);
        }
    }
}

echo $errors['securityquestion'];

if($profile_fields){
    echo '<h1>Security Questions</h1>';
    echo '<form id="security" action="" method="post">';
    foreach ($profile_fields as $profileinfo) {
        echo $profileinfo->name.'<br/>'; //Question Text
        $dataValues = explode("\n",$profileinfo->param1); //Answer Options
        echo '<input type="hidden" name="shortnames[]" value="'.$profileinfo->shortname.'">';
        echo '<select name="'.$profileinfo->shortname.'">';
        echo '<option value="" selected="">Choose...</option>';
        foreach ($dataValues as $data){
            echo '<option value="'.$data.'">'.$data.'</option>';
        }
        echo '</select></br>';
    }
    
    echo '<input type="submit" class="btn btn-primary" name="submitbutton" id="id_submitbutton" value="Submit">';
    echo '</form>';
}
echo $OUTPUT->footer();

?>
<style>
form,select{margin:10px;font-size:20px;}

</style>
